* 51 stage Ring-Osc.
* Modified by Darsen Lu 03/11/2009
* Modified by Tanvir Morshed 12/21/2009
* Modified by S. Whiteley 4/4/10

.param test_ibm=1

.if test_ibm != 0

.param sigma = 0
.cache aaa
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/skewParams.inc
.lib h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/process.lib stats
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/functions.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/fet_adder.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/shared.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/shared_cor_fet.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/fixed_corner.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/fet_dist.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/correlation.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/fet_param.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/esd_globals.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/Schematic/d_nfet.inc
.include h /usr1/cad/IBM_PDK/soi12s0/V1.5.0.0IBM/HSPICE/models/Schematic/d_pfet.inc
.endcache

.else

.include nmos4p3.mod
.include pmos4p3.mod

.endif

vin in out 2 pulse 2 0 0.1n 5n 1 1 1
vdd dd 0 dc 0 pulse 0 1.5 0 1n 1 1 1
vss ss 0 dc 0
ve  sub  0 dc 0

xinv1 dd ss sub in out25 inv25 
xinv2 dd ss sub out25 out50 inv25
xinv5 dd ss sub out50 out inv1
xinv11 dd ss sub out buf inv1
cout  buf ss 1pF

.option itl1=500 gmin=1e-15 itl4=10 
*.option itl1=1000 itl4=20 temp=85 gmin=1e-15 abstol=1e-12 reltol=1e-4
.tran 0.2n 10n
.print tran v(out25) v(out50)


.subckt inv1 dd ss sub in out
.if test_ibm != 0
xmn1  out in  ss  sub  d_nfet  w=4u  l=0.15u  AS=6p AD=6p PS=7u PD=7u pdbcp=0u
xmp1  out in  dd  sub  d_pfet  w=10u l=0.15u  AS=15p AD=15p PS=13u PD=13u pdbcp=0u
.else
mn1  out in  ss  sub  n1  w=4u  l=0.15u  AS=6p AD=6p PS=7u PD=7u pdbcp=0u
mp1  out in  dd  sub  p1  w=10u l=0.15u  AS=15p AD=15p PS=13u PD=13u pdbcp=0u
.endif
.ends inv1

.subckt inv5 dd ss sub in out
xinv1 dd ss sub in 1 inv1
xinv2 dd ss sub 1  2 inv1
xinv3 dd ss sub 2  3 inv1
xinv4 dd ss sub 3  4 inv1
xinv5 dd ss sub 4 out inv1
.ends inv5

.subckt inv25 dd ss sub in out
xinv1 dd ss sub in 1 inv5
xinv2 dd ss sub 1  2 inv5
xinv3 dd ss sub 2  3 inv5
xinv4 dd ss sub 3  4 inv5
xinv5 dd ss sub 4 out inv5
.ends inv25

.control
run
plot v(out25) v(out50)
.endc

.end
